--[[
	ESSENTIAL FILES
	CODENAME : RED DUNE MODS (RDM)
	===================================================================================
	Version 4.x
	
	@Namespaces 
							  [NEW] 				| 	[DEPRECIATED]
		Mod name			: Silva - Mod name		|	
		Mod ClassCore		: RDM_Mod[ClassName]	|	sMod_[ClassName]
		Class 				: RDM_[ClassName]		|	s[ClassName]
		BuildingTemplateID  : RDM_[TemplateID]		|	s[TemplateID]
		Entity 				: RDM_[EntityName]		|	s[EntityName]
		ModItem				: RDM_[ModItemName]		|	s[ModItemName]
		GlobalVars			: g_RDM_[GlobalVarName]	|	g_s[GlobalVarName]
	
	@CoreClasses 
	@Class RDM_Core					: Fonctionnalités précises (Debug, BuildMenu...).
	@Class RDM_ModBase 				: Classe parent pour tous les mods avec des méthodes de base.
	@Class RDM_Controller 			: Gère le débloquage des bâtiments, TechModifier et chargement des mods.
	@Class RDM_Fixer 				: Applications des fixs.
	@Class RDM_ModEssentialFiles	: [DEPRECIATED][REMOVED]Classe du Mod Essential Files.
	@Class RDM_ModLog				: [DEPRECIATED] Gestion des messages du ModLog
	
	@RulesTables
	rules_buildings 	= { { 1 = "building_id", 	2 = "tech_id" }, {...}, }
	rules_upgrades 		= { { 1 = "upgrade_id", 	2 = "tech_id" }, {...}, }
	rules_modifiers 	= { { 1 = "modifier_id",	2 = "label_id", 3 = {"propriety", amount, percent} , 4 = "tech_id" }, {...}, }
	
	@Messages
	Initilisations des classes et des données
	@OnMsg.ClassesBuilt()
		Msg("RDM_CoreLoaded")							Lancer avant la fin de RDM_Core:Init() durant OnMsg.ClassesBuilt()
		Msg("RDM_ControllerLoaded")						Lancer avant la fin de RDM_Controller:Init()
		Msg("RDM_FixerLoaded")							Lancer avant la fin de RDM_Fixer:Init()
		Msg("RDM_ModLoaded", self.class, self.ModID)	Lancer avant la fin de chaque RDM_Mod[ClassName]:Init()
		
	Applications des modifications
	@OnMsg.CityStart()
		Msg("RDM_GatherLockBuildings")
		Msg("RDM_GatherLockCrops")
		Msg("RDM_GatherUnlockUpgrades")
		Msg("RDM_FixerThrowFixes", RDM_Fixer, moment)
	@OnMsg.LoadGame()
		Msg("RDM_AfterControllerGameInit")
		Msg("RDM_SavegameFixups")
		Msg("RDM_GatherLockBuildings")
		Msg("RDM_GatherLockCrops")
		Msg("RDM_GatherUnlockUpgrades")
		Msg("RDM_FixerThrowFixes", RDM_Fixer, moment)
	
	@Variables
	Mods[mod_id]
	CurrentModPath
	CurrentModOptions.MyOptionId
	SharedModEnv
	
	@Msg order
	function OnMsg.ClassesGenerate() end
	function OnMsg.ClassesPreprocess() end
	function OnMsg.ClassesPostprocess() end
	function OnMsg.ClassesBuilt() end
	function OnMsg.CityStart() end
	function OnMsg.LoadGame() end
--]]

-- @Return une table des RDM_Mod[ClassName] chargé dans la partie : 
-- RDM_ModRegister = { RDM_Mod[ClassName] = { [classe content]},  RDM_Mod[ClassName] = { [classe content]}, ... }
RDM_ModRegister = {}
RDM_const = {}

-- @Functions:GetModId
-- ===================================================================================
function GetModID_Core() return "PlbG3SX" end
function GetModID_LanguagePack() return "EstTLA" end

-- function IsModLoaded(mod_id) return ModsLoaded and table.find(ModsLoaded, "id", mod_id) end

-- @Functions:GetModPath
-- ===================================================================================
function GetModPath_Core() return Mods[GetModID_Core()].env.CurrentModPath end

-- @Functions:GetModVersion
-- ===================================================================================
function GetModVersion_Core()
	local mod = Mods[GetModID_Core()]
	return mod.version_major .. "." .. mod.version_minor
end

-- @Functions:ModOptions
-- ===================================================================================
function GetModOption_LanguageSelected() return Mods[GetModID_LanguagePack()].options.language_selected	end 
-- function GetModOption_ScriptDebugger() 	return CurrentModOptions['debug_mode'] end [REMOVED]

-- @Msg:Init
function OnMsg.ClassesBuilt() RDM_Core:Init() end
-- function OnMsg.CityStart()end
-- function OnMsg.LoadGame()  end
function SavegameFixups.RDM_SavegameFixups() RDM_Core:SavegameFixups() end

DefineClass.RDM_Core = {
	CoreModDir = false,
}

function RDM_Core:Init() 
	self.CoreModDir = CurrentModPath
	
	self:Load_TechFieldPresets()
	self:Load_TechPresets()
	self:AddLightColors()
	
	RDM_Controller:Init()
	RDM_Fixer:Init()
	
	ModLog("[SILVA] Core v" .. GetModVersion_Core() .." loaded.")
	Msg("RDM_CoreLoaded")
end

function RDM_Core:SavegameFixups() 
	Msg("RDM_SavegameFixups")
end

function RDM_Core:AddLightColors() 
	NightLightColors['cyan'] = RGB(0, 255, 255)

	NightLightColorNames = {}
	for color,_ in pairs(NightLightColors) do
		NightLightColorNames[#NightLightColorNames + 1] = color
	end
end

-- [DEPRECIATED] v3.x
function RDM_Core:Initialized() return end

-- [DEPRECIATED] v3.x
DefineClass.RDM_ModLog = {
	namespace = "(RDM) ",
}
function RDM_ModLog:Label(text) return self.namespace .. text .. " : " end
function RDM_ModLog:GetError()  return self:Label("[Error]") end
function RDM_ModLog:GetLoaded() return self:Label("[Loaded]") end
function RDM_ModLog:GetFixed() 	return self:Label("[Fixed]") end
function RDM_ModLog:GetMod() 	return self:Label("[Mod]") end
function RDM_ModLog:GetNotice() return self:Label("[Notice]") end
function RDM_ModLog:GetWarning()return self:Label("[Warning]") end
function RDM_ModLog:GetPatched()return self:Label("[Patched]") end